{include file=$tplVar.header}
<link rel="stylesheet" href="https://cdn.datatables.net/2.2.2/css/dataTables.dataTables.min.css">
<script src='https://cdn.datatables.net/2.2.2/js/dataTables.min.js'></script>

<style>
    td{
        vertical-align: middle !important;
        text-align: center !important;
    }

    th{
        text-align: center !important ;
    }

    .action{
        text-align: right !important;
    }

    .cus-alert{
        padding: 2px 5px;
        margin: 1px;
        font-weight: 500;
    }

    .copyAssetId{
        font-size: 11px;
        cursor:pointer;
    }
</style>

<p style="text-align: right;"><label>
    Name: <a href="clientssummary.php?userid={$tplVar['clientDetail']->id}" target="_blank"> {$tplVar['clientDetail']->firstname} {$tplVar['clientDetail']->lastname} </a>
</label></p>
<table class="table" id='myTables'>
    <thead>
        <tr style="background-color: #1a4d80; color:white; ">
            <th >Asset ID</th>
            <th>IP</th>
            <th>ISO Code</th>
            <th>Domain</th>
            <th >Creation Date</th>
            <th>Last Update</th>
            <th>Asset Status</th>
            <th>Issues</th>
            <th>Action</th>
        </tr>
    </thead>
    {if $tplVar['assetsData'] }
        <tbody>
        {foreach from=$tplVar['assetsData'] item=assetsData key=key name=name}
            
                <tr>
                    {assign var="assetId" value={$assetsData['assetId']}|substr:0:10}
                    <td title='{$assetsData['assetId']}' >{$assetId}..   <a  copyvalue='{$assetsData['assetId']}' class='copyAssetId'><i class="fas fa-copy"></i></a></td>
                    <td>
                        {assign var="isocode" value=''}
                        {foreach from=$assetsData['ips'] item=ips key=ipskey}
                            {$ips['ip']}<br>
                            {assign var="isocode" value=$isocode|cat:$ips['isoCode']}
                            {assign var="isocode" value=$isocode|cat:"<br>"}
                        {/foreach}
                    </td>
                    <td>{$isocode}</td>
                    <td>
                        {foreach from=$assetsData['domains'] item=domain key=domainkey}
                            {$domain['domain']}<br>
                        {/foreach}
                    </td>
                    <td>{$assetsData['creationDate']}</td>
                    <td>{$assetsData['lastUpdate']}</td>
                    <td>
                        {if $assetsData['isActive'] == 1}
                            <span class=' alert-success' style="padding: 5px 7px; border-radius: 8px;">Active</span>
                        {else}
                            <span class=' alert-danger' style="padding: 5px 7px; border-radius: 8px;">Inactive</span>
                        {/if}
                    </td>
                    <td>
                        <span class='info alert cus-alert' data-toggle='tooltip' data-placement='bottom' title='Info' style="background:rgb(0 143 251); color:white">{$assetsData['issues']['info']}</span>
                        <span class='low alert cus-alert' data-toggle='tooltip' data-placement='bottom' title='Low' style="background:#4cae4c; color:white">{$assetsData['issues']['low']}</span>
                        <span class='medium alert cus-alert' data-toggle='tooltip' data-placement='bottom' title='Medium' style="background:rgb(253 175 24); color:white">{$assetsData['issues']['medium']}</span>
                        <span class='high alert cus-alert' data-toggle='tooltip' data-placement='bottom' title='High' style="background:rgb(254 68 95); color:white">{$assetsData['issues']['high']}</span>
                        <span class='critical alert cus-alert' data-toggle='tooltip' data-placement='bottom' style="background:rgb(119 93 208); color:white" title='Critical'>{$assetsData['issues']['critical']}</span>
                    </td>
                    <td class='action'>
                        {if $assetsData['reportUrl'] != '' }
                            <a href="{$assetsData['reportUrl']}" class=' btn btn-success' target="_blank"  download><i class="fas fa-file-download"></i> Report</a>
                        {/if}
                        <button assetId="{$assetsData['assetId']}" clientId="{$assetsData['clientId']}" class='updateAsset btn btn-primary'><i class="fas fa-edit"></i> Edit Asset </button>
                    </td>
                </tr> 
           
        {/foreach}
        </tbody>
    {/if}
</table>

<div class="modal fade" id="manageSelectedAsset" tabindex="-1" role="dialog" aria-labelledby="manageSelectedAssetLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
        <h5 class="modal-title" id="manageSelectedAssetLabel">Manage selected Asset</h5>
      </div>
      <from method="POST" action="">
        <div class="modal-body">
            <input type="hidden" name="action" value="manageSelectedAsset">
            <input type="hidden" name="manageClientId" id="manageClientId">
            <input type="hidden" name="manageAssetId" id="manageAssetId">
            <table style="width: 100%;">
                <tr>
                    <td style="width: 150px; text-align: right; padding-right: 5px;"><label for="ip">Enter IP</label></td>
                    <td><textarea name="ip" id="ip" class="form-control"></textarea></td>
                    <td><i class="fas fa-info-circle" title='Please separate multiple IPs with a comma'></i></td>
                </tr>
                <tr>
                    <td style="width: 100px; text-align: right; padding-right: 5px;"><label for="domain">Enter Domain</label></td>
                    <td><textarea  name="domain" id="domain" class="form-control"></textarea></td>
                    <td><i class="fas fa-info-circle" title='Please separate multiple Domains with a comma' ></i></td>
                </tr>
            </table>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            <button type="button" class="btn btn-primary" id='saveManageSelectedAsset'>Save changes</button>
        </div>
      </from>
    </div>
  </div>
</div>

{include file=$tplVar.footer}
<script>
$(document).ready(function(){
        let table = new DataTable('#myTables', {
            ordering: false
        });

        $('.copyAssetId').click(function(){
            navigator.clipboard.writeText($(this).attr('copyvalue'));
            $.growl.notice({ message: 'Copy Asset Id <br>'+$(this).attr('copyvalue') });
        });

        $('.updateAsset').click(function(){
            $('.updateAsset').prop('disabled', true);
            $(this).html('Please Wait <i class="fas fa-spinner fa-spin"></i>');
            $('#manageClientId').val(($(this).attr('clientId')));
            $('#manageAssetId').val(($(this).attr('assetId')));
            var assetDetail = {
                assetId:$(this).attr('assetId'),
                action:"getAssetDetailById"
            }
            $.ajax({
                    type: "POST",
                    url: "",
                    data: assetDetail,
                    dataType: "json",
                    success: function(response){
                        if(response['statuscode'] == 200){
                            ip = response['response_json']['ips'];
                            ipValue='';
                            if(ip.length>0){
                                for (const key in ip) {
                                    ipValue += ip[key]['ip']+','
                                }
                            }

                            domain = response['response_json']['domains'];
                            domainValue='';
                            if(ip.length>0){
                                for (const key in domain) {
                                    domainValue+=domain[key]['domain']+',';
                                }
                            }
                            

                            $('#domain').val(domainValue);
                            $('#ip').val(ipValue);
                            $('#manageSelectedAsset').modal('show');
                        }else{
                            $.growl.error({ message: 'asset Id are not exist ' });
                        }
                    }
            });
            //$('#manageSelectedAsset').modal('show');
        });

        $('#saveManageSelectedAsset').click(function(){
            $(this).prop('disabled', true).html('Please Wait <i class="fas fa-spinner fa-spin"></i>');
            ip = $('#ip').val();
            ip = ip.endsWith(',') ? ip.slice(0, -1) : ip;

            domain = $('#domain').val();
            domain = domain.endsWith(',') ? domain.slice(0, -1) : domain;

            var assetDetail = {
                action:"updateSeparateAssetDetail",
                clientId: $('#manageClientId').val(),
                assetId: $('#manageAssetId').val(),
                ip: ip,
                domain: domain,
            }
            $.ajax({
                    type: "POST",
                    url: "",
                    data: assetDetail,
                    dataType: "json",
                    success: function(response){
                        if(response['statuscode'] == 200){
                            // $.growl.notice({ message: response['response_json']['message'] });
                            $.growl.notice({ message: 'Update Successfully' });
                            setTimeout(function() {
                                    location.reload();
                                }, 2000);  
                        }else{
                            $.growl.error({ message: response['response_json']['message'] });
                            setTimeout(function() {
                                    location.reload();
                                }, 2000);  
                        }
                    }
            });
        });
});

</script>


