<?php
use WHMCS\Module\Addon\Edgewatch\helper;
use WHMCS\Database\Capsule;
use WHMCS\View\Menu\Item as MenuItem;


add_hook('AfterShoppingCartCheckout', 1, function($vars) {
    try{
        foreach($vars['ServiceIDs'] as $service){
            $record = Capsule::table('tblhosting')
            ->join('tblclients','tblclients.id','tblhosting.userid')
            ->where('tblhosting.id',$service)
            ->select('tblhosting.*','tblclients.email')
            ->first();

            $domain = $record->domain;
            $dedicatedip = $record->dedicatedip;
            if( $domain!='' || $dedicatedip!='' ){
                $helper = new helper($vars);
                $helper->createAsset($domain,$dedicatedip,$record->email );
            }
        }
    }catch(Exception $e){
        Capsule::table('mod_edgewatch_log')->insert([
            'action' => 'Hooks::AfterShoppingCartCheckout',
            'request' => '',
            'response' => json_encode(['error-log-type'=> 'on try-catch','message'=>$e->getMessage()],true),
            'statuscode' => 'Error'
        ]);
    }
});

add_hook('ClientAreaHeaderOutput', 1, function($vars) {
    try{

        $helper = new helper($vars);
       if($vars['templatefile'] == 'clientareaproducts'){
            $clientEmail = Capsule::table('tblclients')->where('id',$_SESSION['uid'])->value('email');
            $clientTentId = ($helper->getTenantClients())[$clientEmail]['id'];
            if($clientTentId){
                $clientAreaUserDetail = $helper->clientAreaUserDetail($clientTentId);

                $assetDomain = array();
                foreach($clientAreaUserDetail['getAssetsDetail'] as $domains){
                    foreach ($domains['domains'] as $domain) {
                        $assetDomain[$domain['domain']]['scoring'] = $domains['scoring'];
                        $assetDomain[$domain['domain']]['assetId'] = $domains['assetId'];
                        $assetDomain[$domain['domain']]['issues'] = $domains['issues'];
                    }
                }

                $assetDomain = json_encode($assetDomain);
                return "<script>
                       assetDomain =  $assetDomain;
                        // console.log(assetDomain);
                    $(document).ready(function(){
                        $('#tableServicesList tbody tr td:nth-child(2n) a').each(function() {
                            domain = $(this).html();
                            if (assetDomain.hasOwnProperty(domain)) {
                                if(assetDomain[domain].scoring>6){
                                   html = $(this).parent().find('strong').html();
                                   $(this).parent().find('strong').html( html+ ` 
                                        <i class='fas fa-circle' style='color:rgb(255, 59, 59);' data-toggle='tooltip' data-placement='right' 
                                        title='Scoring: `+assetDomain[domain].scoring+`'></i>
                                   `)
                                }
                                else if(assetDomain[domain].scoring>4){
                                        html = $(this).parent().find('strong').html();
                                        $(this).parent().find('strong').html( html+ ` 
                                            <i class='fas fa-circle' style='color: #FFD43B;'data-toggle='tooltip' data-placement='right' 
                                            title='Scoring: `+assetDomain[domain].scoring+`'></i>
                                        `)
                                }
                                else{
                                    html = $(this).parent().find('strong').html();
                                    $(this).parent().find('strong').html( html+ ` 
                                            <i class='fas fa-circle' style='color:rgb(98, 255, 59);'data-toggle='tooltip' data-placement='right' 
                                            title='Scoring: `+assetDomain[domain].scoring+`'></i>
                                        `)
                                }
                            }
                        });
                    })
                       
                </script>";
            }
       }elseif($vars['templatefile'] == 'clientareaproductdetails'){
            $clientdomain = ($vars['domain']);

            $clientEmail = Capsule::table('tblclients')->where('id',$_SESSION['uid'])->value('email');
            $clientTentId = ($helper->getTenantClients())[$clientEmail]['id'];
           
            if($clientTentId){
                $clientAreaUserDetail = $helper->clientAreaUserDetail($clientTentId);
                
                $assetDomain = array();
                    foreach($clientAreaUserDetail['getAssetsDetail'] as $domains){
                        foreach ($domains['domains'] as $domain) {
                            if($domain['domain'] ==  $clientdomain ){
                                $assetDomain['scoring'] = $domains['scoring'];
                                $assetDomain['assetId'] = $domains['assetId'];
                                $assetDomain['issues'] = $domains['issues'];
                            }   
                        }
                    }
                    
                    
                    $assetDomain = json_encode($assetDomain);
                    return "
                    <style>
                        .cus-alert{
                            padding: 2px 5px;
                            margin: 1px;
                            font-weight: 500;
                        }
                    </style>
                    <script>
                        $('document').ready(function(){
                            assetDomain =  $assetDomain;
                            // console.log(assetDomain);
                            $('.tab-content .card').eq(0).after(`<div class='tenantassetdetail card'>
                                    <div class='card-header'>Tenant Assets Dashboard</div>
                                    <div class='card-body'>
                                        <table>
                                            <tr><td>Asset ID:</td><td> `+assetDomain.assetId+`</td></tr>
                                            <tr><td>Scoring:</td><td> `+assetDomain.scoring+`/10 </td></tr>
                                            <tr><td>Issues:</td><td> `+
                                                `<span data-toggle='tooltip' data-placement='bottom' title='Critical' class='alert cus-alert' style='background:rgb(119 93 208); color:white' >`+ assetDomain.issues.critical+ `</span>`+
                                                `<span data-toggle='tooltip' data-placement='bottom' title='High' class='alert cus-alert' style='background:rgb(254 68 95); color:white'>`+ assetDomain.issues.high +`</span>`+
                                                `<span data-toggle='tooltip' data-placement='bottom' title='Info' class='alert cus-alert' style='background:rgb(0 143 251); color:white'>`+ assetDomain.issues.info +`</span>`+
                                                `<span data-toggle='tooltip' data-placement='bottom' title='Low' class='alert cus-alert' style='background:#4cae4c; color:white'>`+ assetDomain.issues.low +`</span>`+
                                                `<span data-toggle='tooltip' data-placement='bottom' title='Medium' class='alert cus-alert' style='background:rgb(253 175 24); color:white'>`+ assetDomain.issues.medium +`</span>`
                                            +`</td></tr>
                                        </table>
                                    </div>
                                </div>`);
                        });
                    </script>";
                }

       }

    }catch(Exception $e){
        Capsule::table('mod_edgewatch_log')->insert([
            'action' => 'Hooks::AfterShoppingCartCheckout',
            'request' => '',
            'response' => json_encode(['error-log-type'=> 'on try-catch','message'=>$e->getMessage()],true),
            'statuscode' => 'Error'
        ]);
    }
});

add_hook('ClientAreaPrimaryNavbar', 1, function (MenuItem $primaryNavbar)
{
    $helper = new helper($primaryNavbar);
    $clientEmail = Capsule::table('tblclients')->where('id',$_SESSION['uid'])->value('email');
    $clientTentId = ($helper->getTenantClients())[$clientEmail]['id'];
    
    if( $clientTentId){
        $primaryNavbar->addChild('Tenant Assets Dashboard')
        ->setUri("index.php?m=edgewatch")
        ->setOrder(70);
    }
});
