<?php

use WHMCS\Database\Capsule;
use WHMCS\Module\Addon\Edgewatch\Admin\AdminDispatcher;
use WHMCS\Module\Addon\Edgewatch\helper;

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

function edgewatch_config()
{
    return [
        'name' => 'Edgewatch Partner API Integration',
        'description' => 'The Edgewatch WHMCS API Partner Module lets MSPs and hosters manage and fully automate customer enrollment and provisioning while bringing External Attack Surface Management (EASM) right into WHMCS: map products to Edgewatch plans, auto-create tenants on order/upgrade, sync usage and billing via webhooks, handle lifecycle events (suspend/unsuspend/cancel), and issue per-tenant credentials with optional SSO to the Edgewatch portal. Partners can auto-onboard domains, trigger scheduled or on-demand scans, surface exposure/risk scores, alerts, and reports inside WHMCS tickets and dashboards, and push CTI/feed data to downstream tools—delivering a turnkey EASM add-on with zero third-party data dependence and clean, repeatable operations.',
        'author' => 'Edgewatch',
        'language' => 'english',
        'version' => '0.1',

        'fields' => [
            'removeDatabase' => [
                'FriendlyName' => 'Remove Database',
                'Type' => 'yesno',
                'Description' => 'Tick this box to delete the addon module database table on deactivate.',
            ],
        ]
    ];
}


function edgewatch_activate()
{
    // Create custom tables and schema required by your module
    try {
        if(!Capsule::schema()->hasTable('mod_edgewatch_log')){
            Capsule::schema()->create(
                'mod_edgewatch_log',
                function($table){
                    $table->increments('id');
                    $table->string('action');
                    $table->text('request');
                    $table->text('response');
                    $table->text('statuscode');
                    $table->text('ip')->nullable();
                    $table->timestamp('datetime')->useCurrent();
                }
            );
        }

        if (!Capsule::Schema()->hasColumn('mod_edgewatch_log', 'ip')){
            Capsule::schema()->table('mod_edgewatch_log',function($table){
                $table->text('ip')->nullable();
            });
        }

        if(!Capsule::schema()->hasTable('mod_edgewatch_auth')){
            Capsule::schema()->create(
                'mod_edgewatch_auth',
                function($table){
                    $table->increments('id');
                    $table->string('client_id');
                    $table->text('secrete_key');
                    $table->text('token');
                    $table->text('refresh_token');
                    $table->text('api_response');
                    $table->timestamp('datetime')->useCurrent();
                }
            );
        }

        if(!Capsule::schema()->hasTable('mod_edgewatch_user')){
            Capsule::schema()->create(
                'mod_edgewatch_user',
                function($table){
                    $table->increments('id');
                    $table->string('whmcs_client_id');
                    $table->text('edgewatch_client_id');
                    $table->text('value1')->nullable();
                    $table->text('value2')->nullable();
                    $table->text('value3')->nullable();
                    $table->timestamp('datetime')->useCurrent();
                }
            );
        }
        
    } catch (\Exception $e) {
        return [
            // Supported values here include: success, error or info
            'status' => "error",
            'description' => 'Unable to create table schema : ' . $e->getMessage(),
        ];
    }
}

function edgewatch_deactivate()
{
   
    try {
        if(Capsule::table('tbladdonmodules')->where('setting','removeDatabase')->where('module','edgewatch')->where('value','on')->first()){
            Capsule::schema()->dropIfExists('mod_edgewatch_log');
            Capsule::schema()->dropIfExists('mod_edgewatch_auth');
        }
    } catch (\Exception $e) {
        return [
            // Supported values here include: success, error or info
            "status" => "error",
            "description" => "Unable to drop mod_addonexample: {$e->getMessage()}",
        ];
    }
}


function edgewatch_output($vars)
{
   
    $action = isset($_REQUEST['repage']) ? $_REQUEST['repage'] : 'dashboard';
    $dispatcher = new AdminDispatcher;
    $dispatcher->dispatch($action, $vars);
}



function edgewatch_clientarea($vars)
{
    global $whmcs;
    if($whmcs->get_req_var('m') == 'edgewatch' && isset($_SESSION['uid'])){
        $helper = new helper($vars);
        $clientEmail = Capsule::table('tblclients')->where('id',$_SESSION['uid'])->value('email');
        $clientTentId = ($helper->getTenantClients())[$clientEmail]['id'];

        if($clientTentId){


            if(isset($_POST['action']) && $_POST['action'] == 'getAssetDetailById' ){
                echo(json_encode($helper->getAssetDetailById($_POST['assetId'])));
                die();
            }

            if(isset($_POST['action']) && $_POST['action'] == 'updateSeparateAssetDetail' ){
                echo(json_encode( $helper->updateSeparateAssetDetail()));
                die();
            }  

            
            global $CONFIG;
            return array(
                'pagetitle' => 'edgewatch dashboard',
                'breadcrumb' => array('index.php?m=edgewatch' => 'edgewatch'),
                'templatefile' => 'client/edgewatch_dashboard',
                'requirelogin' => true,
                'forcessl' => false,
                'vars' => array(
                    'page_detail' => $vars,
                    'asset'=> $CONFIG["SystemURL"]."/modules/addons/{$whmcs->get_req_var('m')}/assets",
                    'server_name'=> $_SERVER['REQUEST_URI'],
                    'userid'=> $_SESSION['uid'],
                    'userDetail'=> $helper->clientAreaUserDetail($clientTentId),
                    'clientEmail' => $clientEmail
                ),
        
            );
        }
    }
}


