// CalendarInfo Object structure
const CalendarInfo = {
    contributionCount: Number,
    contributionLevel: Number,
    date: Date,
};

// LangInfo Object structure
const LangInfo = {
    language: String,
    color: String,
    contributions: Number,
};

// UserInfo Object structure
const UserInfo = {
    isHalloween: Boolean,
    contributionCalendar: Array, // Array of CalendarInfo objects
    contributesLanguage: Array, // Array of LangInfo objects
    totalContributions: Number,
    totalCommitContributions: Number,
    totalIssueContributions: Number,
    totalPullRequestContributions: Number,
    totalPullRequestReviewContributions: Number,
    totalRepositoryContributions: Number,
    totalForkCount: Number,
    totalStargazerCount: Number,
};

// ContributionLevel type
const ContributionLevel = {
    NONE: 'NONE',
    FIRST_QUARTILE: 'FIRST_QUARTILE',
    SECOND_QUARTILE: 'SECOND_QUARTILE',
    THIRD_QUARTILE: 'THIRD_QUARTILE',
    FOURTH_QUARTILE: 'FOURTH_QUARTILE',
};

// RadarContribSettings Object structure
const RadarContribSettings = {
    backgroundColor: String,
    foregroundColor: String,
    weakColor: String,
    radarColor: String,

    growingAnimation: Boolean, // Optional

    fileName: String, // Optional

    l10n: {
        commit: String,
        repo: String,
        review: String,
        pullreq: String,
        issue: String,
    }, // Optional
};

// PieLangSettings Object structure
const PieLangSettings = {
    backgroundColor: String,
    foregroundColor: String,

    growingAnimation: Boolean, // Optional

    fileName: String, // Optional
};

// BaseSettings Object structure (inherits from RadarContribSettings and PieLangSettings)
const BaseSettings = {
    backgroundColor: String,
    foregroundColor: String,
    strongColor: String,
    weakColor: String,
    radarColor: String,

    growingAnimation: Boolean, // Optional

    fileName: String, // Optional

    l10n: {
        commit: String,
        repo: String,
        review: String,
        pullreq: String,
        issue: String,
        contrib: String,
    }, // Optional
};

// NormalColorSettings Object structure (extends BaseSettings)
const NormalColorSettings = {
    type: 'normal',
    contribColors: [String, String, String, String, String], // Array of 5 strings
};

// SeasonColorSettings Object structure (extends BaseSettings)
const SeasonColorSettings = {
    type: 'season',
    contribColors1: [String, String, String, String, String], // Spring (Mar - Jun)
    contribColors2: [String, String, String, String, String], // Summer (Jun - Sep)
    contribColors3: [String, String, String, String, String], // Autumn (Sep - Dec)
    contribColors4: [String, String, String, String, String], // Winter (Dec - Mar)
};

// RainbowColorSettings Object structure (extends BaseSettings)
const RainbowColorSettings = {
    type: 'rainbow',
    saturation: String,
    contribLightness: [String, String, String, String, String], // Array of lightness strings
    duration: String, // e.g., '10s'
    hueRatio: Number, // hue per week
};

// PanelPattern Object structure
const PanelPattern = {
    width: Number,
    bitmap: [Number, String], // Array of numbers or hex-strings
};

// TopPanelPattern Object structure (extends PanelPattern)
const TopPanelPattern = {
    backgroundColor: String,
    foregroundColor: String,
};

// SidePanelPattern Object structure (extends PanelPattern)
const SidePanelPattern = {
    backgroundColor: String, // Optional
    foregroundColor: String, // Optional
};

// ContribPattern Object structure
const ContribPattern = {
    top: TopPanelPattern,
    left: SidePanelPattern,
    right: SidePanelPattern,
};

// BitmapPatternSettings Object structure (extends BaseSettings)
const BitmapPatternSettings = {
    type: 'bitmap',
    contribPatterns: [
        ContribPattern,
        ContribPattern,
        ContribPattern,
        ContribPattern,
        ContribPattern
    ], // Array of 5 ContribPattern objects
};

// PieLangOnlySettings Object structure (extends PieLangSettings)
const PieLangOnlySettings = {
    type: 'pie_lang_only',
};

// RadarContribOnlySettings Object structure (extends RadarContribSettings)
const RadarContribOnlySettings = {
    type: 'radar_contrib_only',
};

// FullSettings type union
const FullSettings = [
    NormalColorSettings,
    SeasonColorSettings,
    RainbowColorSettings,
    BitmapPatternSettings,
];

// Settings type union
const Settings = [
    FullSettings,
    PieLangOnlySettings,
    RadarContribOnlySettings,
];

// SettingFile type, which can be a single Settings object or an array of Settings objects
const SettingFile = [Settings, Array]; // Can be a single object or an array of Settings
