{* impersonate for link *}

<link rel="stylesheet" href="{$asset}/css/jquery.growl.css">
<script src="{$asset}/js/jquery.growl.js"></script>

<link rel="stylesheet" href="https://cdn.datatables.net/2.2.2/css/dataTables.dataTables.min.css">
<script src='https://cdn.datatables.net/2.2.2/js/dataTables.min.js'></script>


<style>
td.fieldlabel {
    text-align: left;
    max-width: 120px;
    padding-right: 10px;
    border: 1px solid #ddd;
    font-size: 16px;
    vertical-align: middle;
    padding: 12px 24px !important;
}

   td.fieldarea {
      text-align: left;
    border: 1px solid #ddd;
    font-size: 16px;
    vertical-align: middle;
    padding: 12px 24px !important;
   }


   table.form {
      width: 100%;
      min-width: 400px;
   }

   table.form label {
      margin: 0px !important;

   }

   .fieldlabel label {
      font-weight: bold;
   }

   table.form td {
      padding: 5px;
   }

   .cus-btn-primary {
    padding: 7px 11px !important;
    font-size: 15px !important;
}


   #assetdata {
      width: 100%;
      font-size: 14px !important;
   }

   #assetdata td {
      vertical-align: middle !important;
      text-align: center !important;
   }

   #assetdata th {
      text-align: center !important;
   }

   #assetdata .action {
      text-align: right !important;
   }

   #assetdata .cus-alert {
      padding: 2px 5px;
      margin: 1px;
      font-weight: 500;
   }

   .action .btn {
      width: 29px;
      height: 29px;
      padding: 4px;
      font-size: 12px;
      text-align: center;
   }
   .assetdata-container {
    margin-top: 20px;
}
.dt-length label {
    margin-left: 10px;
}
h2.assetdata-header {
    font-size: 28px;
    text-align: center;
    margin-bottom: 20px;
    color: #000;
    font-weight: 600;
}
</style>

<h2 class='assetdata-header'>{$page_detail['_lang']['dashboard']}</h2>
<table class="form">
   <tr>
      <td class='fieldlabel'><label>{$page_detail['_lang']['ClientId']} : </label></td>
      <td class="fieldarea">
      {* <label>{$userDetail['id']}</label>  *}
      <a class="btn btn-primary cus-btn-primary" href='{$userDetail['impersonate']}'>{$page_detail['_lang']['login']} <i class="fas fa-sign-in-alt"></i></a></td>
   </tr>
   {foreach from=$userDetail['users'] item=user }
      {if $user['email'] == $clientEmail}
         <tr>
            <td class='fieldlabel'><label>{$page_detail['_lang']['Name']}:</label></td>
            <td class="fieldarea"><label>{$user['name']} {$user['surname']}</label> </td>
         </tr>
         <tr>
            <td class='fieldlabel'><label>{$page_detail['_lang']['Email']}:</label></td>
            <td class="fieldarea"><label>{$clientEmail}</label></td>
         </tr>
         <tr>
            <td class='fieldlabel'><label>{$page_detail['_lang']['position']}:</label></td>
            <td class="fieldarea"><label>{$user['position']}</label></td>
         </tr>
      {/if}
   {/foreach}
   <tr>
      <td class='fieldlabel'><label>{$page_detail['_lang']['CompanyName']}:</label></td>
      <td class="fieldarea"><label>{$userDetail['company']}</label></td>
   </tr>
   <tr>
      <td class='fieldlabel'><label>{$page_detail['_lang']['Plan']}:</label></td>
      <td class="fieldarea"><label>{$userDetail['planName']}</label></td>
   </tr>
   {* <tr><td class='fieldlabel'><label>Status:</label></td><td class="fieldarea"><label>{$userDetail['active']}</label></td></tr> *}
   <tr>
      <td class='fieldlabel'><label>{$page_detail['_lang']['AccountType']}:</label></td>
      <td class="fieldarea"><label>{$userDetail['type']}</label></td>
   </tr>
   <tr>
      <td class='fieldlabel'><label>{$page_detail['_lang']['Scoring']}:</label></td>
      <td class="fieldarea"><label>{$userDetail['scoring']}/10</label></td>
   
</table>
<div class='assetdata-container'>
      <h2 class='assetdata-header' >{$page_detail['_lang']['Assets']}</h2>
      <table id='assetdata' border=1 style="border-color: #ddd;" >
         <thead>
            <tr style="padding: 0px; background-color: #1a4d80; border-color:#334d6600;; color: white;">
               {* <td style="width: 100px;">Asset Id</td> *}
               <td>{$page_detail['_lang']['IP']}</td>
               <td>{$page_detail['_lang']['ISOCode']}</td>
               <td>{$page_detail['_lang']['Domain']}</td>
               {* <td>Creation Date</td>
            <td>Lase Update</td> *}
               <td>{$page_detail['_lang']['Status']}</td>
               <td>{$page_detail['_lang']['Issue']}</td>
               <td>{$page_detail['_lang']['Action']}</td>
            </tr>
         </thead>
         <tbody>
            {foreach from=$userDetail['getAssetsDetail'] item=assetsData key=key name=name}

               <tr>
                  {* <td>{$assetsData['assetId']}</td> *}
                  <td>
                     {assign var="isocode" value=''}
                     {foreach from=$assetsData['ips'] item=ips key=ipskey}
                        {$ips['ip']}<br>
                        {assign var="isocode" value=$isocode|cat:$ips['isoCode']}
                        {assign var="isocode" value=$isocode|cat:"<br>"}
                     {/foreach}
                  </td>
                  <td>{$isocode}</td>
                  <td>
                     {foreach from=$assetsData['domains'] item=domain key=domainkey}
                        {$domain['domain']}<br>
                     {/foreach}
                  </td>
                  {* <td>{$assetsData['creationDate']}</td>
                     <td>{$assetsData['lastUpdate']}</td> *}
                  <td>
                     {if $assetsData['isActive'] == 1}
                        <span class=' alert-success' style="padding: 5px 7px; border-radius: 8px;">Active</span>
                     {else}
                        <span class=' alert-danger' style="padding: 5px 7px; border-radius: 8px;">Inactive</span>
                     {/if}
                  </td>
                  <td>
                     <span class='info alert cus-alert' title='Info' data-toggle='tooltip' data-placement='bottom'
                        style="background:rgb(0 143 251); color:white">{$assetsData['issues']['info']}</span>
                     <span class='low alert cus-alert' title='Low' data-toggle='tooltip' data-placement='bottom'
                        style="background:#4cae4c; color:white">{$assetsData['issues']['low']}</span>
                     <span class='medium alert cus-alert' title='Medium' data-toggle='tooltip' data-placement='bottom'
                        style="background:rgb(253 175 24); color:white">{$assetsData['issues']['medium']}</span>
                     <span class='high alert cus-alert' title='High' data-toggle='tooltip' data-placement='bottom'
                        style="background:rgb(254 68 95); color:white">{$assetsData['issues']['high']}</span>
                     <span class='critical alert cus-alert' style="background:rgb(119 93 208); color:white" data-toggle='tooltip' data-placement='bottom'
                        title='Critical'>{$assetsData['issues']['critical']}</span>
                  </td>
                  <td class='action'>
                     {if $assetsData['reportUrl'] != '' }
                        <a href="{$assetsData['reportUrl']}" class=' btn btn-success' target="_blank" download><i
                              class="far fa-file-pdf"></i> </a>
                     {/if}
                     <button assetId="{$assetsData['assetId']}" clientId="{$assetsData['clientId']}"
                        class='updateAsset btn btn-primary'><i class="fas fa-edit"></i> </button>
                  </td>
               </tr>

            {/foreach}
         </tbody>
      </table>
</div>

<div class="modal fade" id="manageSelectedAsset" tabindex="-1" role="dialog" aria-labelledby="manageSelectedAssetLabel"
   aria-hidden="true">
   <div class="modal-dialog" role="document">
      <div class="modal-content">
         <div class="modal-header">
            <h5 class="modal-title" id="manageSelectedAssetLabel">{$page_detail['_lang']['modal1']['header']}</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
               <span aria-hidden="true">&times;</span>
            </button>
         </div>
         <from method="POST" action="">
            <div class="modal-body">
               <input type="hidden" name="action" value="manageSelectedAsset">
               <input type="hidden" name="manageClientId" id="manageClientId">
               <input type="hidden" name="manageAssetId" id="manageAssetId">
               <table style="width: 100%;">
                  <tr>
                     <td style="width: 150px; text-align: right; padding-right: 5px;"><label for="ip">{$page_detail['_lang']['modal1']['EnterIP']}</label>
                     </td>
                     <td><textarea name="ip" id="ip" class="form-control"></textarea></td>
                     <td><i class="fas fa-info-circle" title='{$page_detail['_lang']['modal1']['EnterIPDesc']}'></i></td>
                  </tr>
                  <tr>
                     <td style="width: 100px; text-align: right; padding-right: 5px;"><label for="domain">{$page_detail['_lang']['modal1']['EnterDomain']}</label></td>
                     <td><textarea name="domain" id="domain" class="form-control"></textarea></td>
                     <td><i class="fas fa-info-circle" title='{$page_detail['_lang']['modal1']['EnterDomainDesc']}'></i></td>
                  </tr>
               </table>
            </div>
            <div class="modal-footer">
               <button type="button" class="btn btn-secondary" data-dismiss="modal">{$page_detail['_lang']['Close']}</button>
               <button type="button" class="btn btn-primary" id='saveManageSelectedAsset'>{$page_detail['_lang']['Savechanges']}</button>
            </div>
         </from>
      </div>
   </div>
</div>


<script>
   $(document).ready(function() {


      let table = new DataTable('#assetdata', {
            
        });

      $('.updateAsset').click(function() {
         $('.updateAsset').prop('disabled', true);
         $(this).html('<i class="fas fa-spinner fa-spin"></i>');
         $('#manageClientId').val(($(this).attr('clientId')));
         $('#manageAssetId').val(($(this).attr('assetId')));
         var assetDetail = {
            assetId: $(this).attr('assetId'),
            action: "getAssetDetailById"
         }
         $.ajax({
            type: "POST",
            url: "",
            data: assetDetail,
            dataType: "json",
            success: function(response) {
               if (response['statuscode'] == 200) {
                  ip = response['response_json']['ips'];
                  ipValue = '';
                  if (ip.length > 0) {
                     for (const key in ip) {
                        ipValue += ip[key]['ip'] + ','
                     }
                  }

                  domain = response['response_json']['domains'];
                  domainValue = '';
                  if (ip.length > 0) {
                     for (const key in domain) {
                        domainValue += domain[key]['domain'] + ',';
                     }
                  }


                  $('#domain').val(domainValue);
                  $('#ip').val(ipValue);
                  $('#manageSelectedAsset').modal('show');
               } else {
                  $.growl.error({ message: 'asset Id are not exist ' });
               }
            }
         });
         //$('#manageSelectedAsset').modal('show');
      });

      $('#saveManageSelectedAsset').click(function() {
         $(this).prop('disabled', true).html('Please Wait <i class="fas fa-spinner fa-spin"></i>');
         ip = $('#ip').val();
         ip = ip.endsWith(',') ? ip.slice(0, -1) : ip;

         domain = $('#domain').val();
         domain = domain.endsWith(',') ? domain.slice(0, -1) : domain;

         var assetDetail = {
            action: "updateSeparateAssetDetail",
            clientId: $('#manageClientId').val(),
            assetId: $('#manageAssetId').val(),
            ip: ip,
            domain: domain,
         }
         $.ajax({
            type: "POST",
            url: "",
            data: assetDetail,
            dataType: "json",
            success: function(response) {
               if (response['statuscode'] == 200) {
                  // $.growl.notice({ message: response['response_json']['message'] });
                  $.growl.notice({ message: 'Update Successfully' });
                  setTimeout(function() {
                     location.reload();
                  }, 2000);
               } else {
                  $.growl.error({ message: response['response_json']['message'] });
                  setTimeout(function() {
                     location.reload();
                  }, 2000);
               }
            }
         });
      });
   });
</script>
{* <pre>
{print_r($userDetail)} *}