{include file=$tplVar.header}
<link rel="stylesheet" href="https://cdn.datatables.net/2.2.2/css/dataTables.dataTables.min.css">
<script src='https://cdn.datatables.net/2.2.2/js/dataTables.min.js'></script>

<style>
.action{
        text-align: right !important;
    }

    .cus-alert{
        padding: 2px 5px;
        margin: 1px;
        font-weight: 500;
    }

    .progress-container {
            width: 100%;
            background-color: #e0e0e0;
            border-radius: 20px;
            overflow: hidden;
        }
        .progress-bar {
            
            height: 25px;
            background-color: #4caf50;
            text-align: center;
            color: #fff;
            line-height: 25px;
            font-weight: bold;
            transition: width 0.5s;
            padding-left: 0px;
        }

</style>
<table class="table" id='myTables'>
    <thead>
        <tr style="background-color: #1a4d80; color:white; ">
            <th><input type="checkbox" name="" id="select-all">     </th>
            <th style="text-align:center;">Name</th>
            <th style="text-align:center;">Email</th>
            <th style="text-align:center;">Company Name</th>
            {* <th style="text-align:center;">Sync Client ID</th> *}
            <th style="text-align:center;">Plan</th>
            <th style="text-align:center;" >Total Assets</th>
            <th style="text-align:center;" >Scoring</th>
            <th style="text-align:center;" >Issues</th>
            <th style="text-align:center;">Action</th>
        </tr>
    </thead>
    <tbody>
        {foreach from=$tplVar['users'] item=item key=key }
            <tr>
                <td style="vertical-align: middle;">
                    {if !$tplVar['tenantClients'][$item->email]['id']}
                        <input type="checkbox" name="" id="select-{$item->id}" class="select-client">     
                    {/if}
                </td>
                <td style="text-align: center;  vertical-align: middle;"><a href="clientssummary.php?userid={$item->id}" target="_blank">{$item->firstname } {$item->lastname }</a></td>
                <td style="text-align: center;  vertical-align: middle;">{$item->email}</td>
                <td style="text-align: center;  vertical-align: middle;">{if $item->companyname!=''} {$item->companyname} {else}..{/if}</td>
                {* <td style="text-align: center;  vertical-align: middle;">{if $tplVar['tenantClients'][$item->email]['id']} {$tplVar['tenantClients'][$item->email]['id']} {else} .. {/if}</td> *}
                <td style="text-align: center;  vertical-align: middle;">{if $tplVar['tenantClients'][$item->email]['id']} {$tplVar['tenantClients'][$item->email]['planName']} {else} .. {/if}</td>
                <td style="text-align: center;  vertical-align: middle;">{if $tplVar['tenantClients'][$item->email]['id']} {$tplVar['tenantClients'][$item->email]['totalAsset']} {else} .. {/if}</td>
                <td style="text-align: center;  vertical-align: middle;">
                    {if $tplVar['tenantClients'][$item->email]['id']} 
                        <div class="progress-container">
                            <div class="progress-bar" style="width: {($tplVar['tenantClients'][$item->email]['scoring']/10)*100}%;">{$tplVar['tenantClients'][$item->email]['scoring']}/10 </div>
                        </div>
                    {else} 
                        .. 
                    {/if}
                </td>
                <td style="text-align: center;  vertical-align: middle;">
                    {if $tplVar['tenantClients'][$item->email]['id']} 
                            <span class='info alert cus-alert' data-toggle='tooltip' data-placement='bottom' title='Info' style="background:rgb(0 143 251); color:white">{$tplVar['tenantClients'][$item->email]['clientIssue']['stats']['info']}</span>
                            <span class='low alert cus-alert' data-toggle='tooltip' data-placement='bottom' title='Low' style="background:#4cae4c; color:white">{$tplVar['tenantClients'][$item->email]['clientIssue']['stats']['low']}</span>
                            <span class='medium alert cus-alert' data-toggle='tooltip' data-placement='bottom' title='Medium' style="background:rgb(253 175 24); color:white">{$tplVar['tenantClients'][$item->email]['clientIssue']['stats']['medium']}</span>
                            <span class='high alert cus-alert' data-toggle='tooltip' data-placement='bottom' title='High' style="background:rgb(254 68 95); color:white">{$tplVar['tenantClients'][$item->email]['clientIssue']['stats']['high']}</span>
                            <span class='critical alert cus-alert' data-toggle='tooltip' data-placement='bottom' style="background:rgb(119 93 208); color:white" title='Critical'>{$tplVar['tenantClients'][$item->email]['clientIssue']['stats']['critical']}</span>
                    {/if}
                </td>
                <td style="text-align: right;  vertical-align: middle;">
                    {if $tplVar['tenantClients'][$item->email]['id']}
                        <a class='btn  btn-info' href='?module=edgewatch&repage=manageclientasset&wc={$item->id}&clientid={$tplVar['tenantClients'][$item->email]['id']}' ><i class="fas fa-info-circle"></i> Manage Assets</a>
                        <a class='btn btn-primary' href="{$tplVar['tenantClients'][$item->email]['impersonate']}" ><i class="fas fa-sign-in-alt"></i> Login</a>
                    {else}
                        <button class="btn btn-success Sync-single-account" onclick="syncUser({$item->id})" id="sync-button-{$item->id}"><i class="fas fa-sync"></i> Sync</button>
                    {/if}
                </td>
            </tr>
        {/foreach}
    </tbody>
</table>

<button class="btn btn-success" id='batch-sync-client' ><i class="fas fa-sync"></i> Batch Sync Client</button>





{include file=$tplVar.footer}
<script>
    $(document).ready(function(){
        let table = new DataTable('#myTables', {
            ordering: false
        });

        // Initialize the array to hold selected client values
        let selectedClients = [];

        $('#select-all').change(function() {
            if ($(this).prop('checked')) {
                $('.select-client').prop('checked', true);
                $('.select-client').each(function() {
                    let clientId = $(this).attr('id').split("-")[1]; 
                    if (!selectedClients.includes(clientId)) {
                        selectedClients.push(clientId);
                    }
                });
            } else {
                $('.select-client').prop('checked', false);
                selectedClients = [];
            }
        });

       
        $('.select-client').change(function() {

            let clientId = $(this).attr('id').split("-")[1]; 
            if ($(this).prop('checked')) {
                if (!selectedClients.includes(clientId)) {
                    selectedClients.push(clientId);
                }
            } else {
                selectedClients = selectedClients.filter(id => id !== clientId);
            }

            if($('.select-client:checked').length === $('.select-client').length){
                $('#select-all').prop('checked', true);
            }else{
                $('#select-all').prop('checked', false);
            }
        });

        $('#batch-sync-client').click(function(){
            if(selectedClients.length>0){
                syncUser(selectedClients.join(','));
            }else{
                $.growl.error({ message:'client are not selected'});
            }
        });
    });

    
    function syncUser(id){
        if( $('#sync-button-'+id).length>0){
            $('#sync-button-'+id).html(' <i class="fas fa-spinner fa-spin"></i> please wait');
        }else{
            $('#batch-sync-client').html(' <i class="fas fa-spinner fa-spin"></i> please wait');
        }
        $('.Sync-single-account,#batch-sync-client').prop('disabled','disabled');

        var syncUser = {
            clientid:id,
            action:"syncUser"
        }
        $.ajax({
        type: "POST",
        url: "",
        data: syncUser,
        dataType: "json",
        success: function(data){
            if(data.status=='multiple'){
                message = data.message;
                for (key in message) {
                      $response = message[key]['message'];
                      if(message[key]['status'] == 'success'){
                            $.growl.notice({ message: key+message[key]['message'] });
                                setTimeout(function() {
                                    location.reload();
                                }, 2000);       
                      }else{
                        $.growl.error({ message: key+message[key]['message'] });
                                setTimeout(function() {
                                    location.reload();
                                }, 2000);  
                      }
                    }
            }
           else if(data.status=='success'){
            $.growl.notice({ message: data.message });
            setTimeout(function() {
                location.reload();
            }, 2000);
           }else{
            $.growl.error({ message: data.message });
            setTimeout(function() {
                location.reload();
            }, 2000);
           }
        }
        });
    }
</script>

{* <pre>
{print_r($tplVar['tenantClients'])} *}