<?php

namespace WHMCS\Module\Addon\Edgewatch;

use Exception;
use WHMCS\Database\Capsule;
use WHMCS\Module\Addon\Edgewatch\Api;
use WHMCS\Module\Addon\Edgewatch\Country;

use function PHPSTORM_META\type;

class helper
{

    public function __construct($params = null)
    {
        if ($params == null) {
        } else {
            $this->checkApiToken();
        }
    }

    //check api token are active or not
    public function checkApiToken()
    {

        try {
            $getApiDetail = Capsule::table('mod_edgewatch_auth')->first();
            $client_id = $getApiDetail->client_id;
            $secrete_key = $getApiDetail->secrete_key;

            if ($client_id != '' && $secrete_key != '') {
                $api = new Api();
                $responseapi =  $api->getTenantDetail(); // get current token parent tenant detail 

                if ($responseapi['statuscode'] != 200) {
                    $responseapi = $api->createApiToken($client_id, $secrete_key); // create token again

                    if ($responseapi['statuscode'] != 200) {
                        $this->returnStatus(__FUNCTION__, 'error', 'Not Token is Re-Generate, please check previous log ');
                    } else {
                        Capsule::table('mod_edgewatch_auth')->delete();
                        Capsule::table('mod_edgewatch_auth')->insert([
                            'client_id' => $client_id,
                            'secrete_key' => $secrete_key,
                            'token' => $responseapi['response_json']['token'],
                            'refresh_token'  => $responseapi['response_json']['refreshToken'],
                            'api_response' => json_encode($responseapi['response_json'])
                        ]);

                        $this->returnStatus(__FUNCTION__, 'success', ' Token is Re-Generate Succfully');
                    }
                } else {
                    $this->returnStatus(__FUNCTION__, 'success', 'Token is ok');
                }
            } else {
                $this->returnStatus(__FUNCTION__, 'error', 'Invalids auth detail or token are not generate');
            }
        } catch (Exception $e) {
            $this->errorLog(__FUNCTION__, 'error', $e->getMessage());
        }
    }

    //generate api token
    public function generateApiToken()
    {
        try {
            if (isset($_POST['secrete_key']) && isset($_POST['client_id'])) {
                $api = new Api();
                $responseapi =  $api->createApiToken($_POST['client_id'], secreteKey: $_POST['secrete_key']);

                if ($responseapi['status'] == 'success') {

                    Capsule::table('mod_edgewatch_auth')->delete();
                    Capsule::table('mod_edgewatch_auth')->insert([
                        'client_id' => $_POST['client_id'],
                        'secrete_key' => $_POST['secrete_key'],
                        'token' => $responseapi['response_json']['token'],
                        'refresh_token'  => $responseapi['response_json']['refreshToken'],
                        'api_response' => json_encode($responseapi['response_json'])
                    ]);

                    $responseapi['message'] = 'Token are generate successfully.';
                    $responseapi['response_json'] = '';
                }


                return $responseapi;
            } else {
                return $this->returnStatus('generate api token', 'error', "client id and secrete key are required field ");
            }
        } catch (Exception $e) {
            $this->errorLog(__FUNCTION__, 'error', $e->getMessage());
        }
    }

    //current token partner detail
    public function getApiUser()
    {
        try {
            $token = Capsule::table('mod_edgewatch_auth')->value('token');
            if ($token != '') {
                $api = new Api();
                $response =  $api->getTenantDetail();
                return $response['response_json']['name'];
            } else {
                $this->returnStatus(__FUNCTION__, 'error', 'Invalids auth detail or token are not generate');
                return '';
            }
        } catch (Exception $e) {
            $this->errorLog(__FUNCTION__, 'error', $e->getMessage());
        }
    }

    public function getApiUserAllDetail()
    {
        try {
            $token = Capsule::table('mod_edgewatch_auth')->value('token');
            if ($token != '') {
                $api = new Api();
                $response =  $api->getTenantDetail();
                return $response;
            } else {
                $this->returnStatus(__FUNCTION__, 'error', 'Invalids auth detail or token are not generate');
                return '';
            }
        } catch (Exception $e) {
            $this->errorLog(__FUNCTION__, 'error', $e->getMessage());
        }
    }

    public function getAllTentClientDetail()
    {
        try {
            $token = Capsule::table('mod_edgewatch_auth')->value('token');
            if ($token != '') {
                $api = new Api();
                $response =  $api->getTenantDetail();
                return $response['response_json'];
            } else {
                $this->returnStatus(__FUNCTION__, 'error', 'Invalids auth detail or token are not generate');
                return '';
            }
        } catch (Exception $e) {
            $this->errorLog(__FUNCTION__, 'error', $e->getMessage());
        }
    }

    public function getTentIssue()
    {
        try {
            $token = Capsule::table('mod_edgewatch_auth')->value('token');
            if ($token != '') {
                $api = new Api();
                $response =  $api->getTentIssue();
                return $response['response_json'];
            } else {
                $this->returnStatus(__FUNCTION__, 'error', 'Invalids auth detail or token are not generate');
                return '';
            }
        } catch (Exception $e) {
            $this->errorLog(__FUNCTION__, 'error', $e->getMessage());
        }
    }

    public function getTentClientAllAssets()
    {
        try {
            $token = Capsule::table('mod_edgewatch_auth')->value('token');
            if ($token != '') {
                $api = new Api();
                $response =  $api->getTenantAllAssets();
                return $response['response_json'];
            } else {
                $this->returnStatus(__FUNCTION__, 'error', 'Invalids auth detail or token are not generate');
                return '';
            }
        } catch (Exception $e) {
            $this->errorLog(__FUNCTION__, 'error', $e->getMessage());
        }
    }

    //delete api token
    public function deleteApiToken()
    {
        try {
            Capsule::table('mod_edgewatch_auth')->delete();
            return ['action' => __FUNCTION__, 'status' => 'success', 'message' => "Remove Api Token"];
        } catch (Exception $e) {
            $this->errorLog(__FUNCTION__, 'error', $e->getMessage());
        }
    }

    //sync user
    public function syncUser()
    {
        try {
            if (isset($_POST['action'])   && isset($_POST['clientid'])) {
                $token = Capsule::table('mod_edgewatch_auth')->value('token');
                if ($token != '') {
                    $api = new Api();
                    $users  = explode(',', $_POST['clientid']);
                    $response = ['status' => 'multiple'];
                    foreach ($users as $key => $user) {
                        $responseapi = $api->createTenantClients($user);

                        if ($responseapi['statuscode'] == 200) {

                            $clientRecords = Capsule::table('tblhosting')
                                ->join('tblclients', 'tblclients.id', 'tblhosting.userid')
                                ->where('tblhosting.userid', $_POST['clientid'])
                                ->select('tblhosting.*', 'tblclients.email')
                                ->get();
                            foreach ($clientRecords as $key => $record) {
                                $domain = $record->domain;
                                $dedicatedip = $record->dedicatedip;
                                if ($domain != '' || $dedicatedip != '') {
                                    $this->createAsset($domain, $dedicatedip, $record->email);
                                }
                            }
                            $response['message']["clietId:$user"] =  ['action' => __FUNCTION__, 'status' => 'success', 'message' => $responseapi['response_json']['message']];
                        } elseif ($responseapi['statuscode'] == 5000) {
                            $response['message']["clietId:$user"] = ['action' => __FUNCTION__, 'status' => 'error', 'message' => $responseapi['message']];
                        } else {
                            $response['message']["clietId:$user"] = ['action' => __FUNCTION__, 'status' => 'error', 'message' => $responseapi['response_json']['errors']];
                        }
                    }
                    return $response;
                } else {
                    $this->returnStatus(__FUNCTION__, 'error', 'Invalids auth detail or token are not generate');
                    return ['status' => 'error', 'message' => 'user are not sync, please check logs'];
                }
            } else {
                $this->returnStatus(__FUNCTION__, 'error', 'user are not sync');
                return ['status' => 'error', 'message' => 'user are not sync'];
            }
        } catch (Exception $e) {
            $this->errorLog(__FUNCTION__, 'error', $e->getMessage());
        }
    }

    //get all partner client
    public function getTenantClients()
    {
        try {
            $token = Capsule::table('mod_edgewatch_auth')->value('token');
            if ($token != '') {
                $api = new Api();
                $responseapi = $api->getApiTenantClients();

                if ($responseapi['statuscode'] == 200) {

                    $tenantClient = [];
                    foreach ($responseapi['response_json'] as $key => $value) {
                        $id = $value['id'];
                        $impersonate = $value['impersonate'];
                        $planName = $value['planName'];
                        $totalAsset = sizeof($value['assets']);
                        $asset = $value['assets'];
                        $scoring = $value['scoring'];
                        $clientIssue = $api->getClientIssue($id)['response_json'];
                        foreach ($value['users'] as $userkey => $uservalue) {
                            $tenantClient[$uservalue['email']] = ['id' => $id, 'impersonate' => $impersonate, 'planName' => $planName, 'totalAsset' => $totalAsset, 'asset' => $asset, 'scoring' => $scoring, 'clientIssue' => $clientIssue];
                        }
                    }

                    return $tenantClient;
                }
            }
        } catch (Exception $e) {
            $this->errorLog(__FUNCTION__, 'error', $e->getMessage());
        }
    }

    public function createAsset($domain, $dedicatedip, $userEmail)
    {
        try {


            $id = ($this->getTenantClients())[$userEmail]['id'];

            if ($id) {
                $data = [
                    'assets' => [
                        [
                            'clientId' => $id,
                            'domains' => [
                                $domain
                            ],
                            'ips' => [
                                $dedicatedip
                            ]
                        ]
                    ]
                ];
                $api = new Api();
                $responseapi = $api->createAsset($data);
            } else {
                throw new Exception("$userEmail is not exist on Tenant Client");
            }
        } catch (Exception $e) {
            $this->errorLog(__FUNCTION__, 'error', $e->getMessage());
        }
    }

    public function getAssetDetailById($assetId)
    {
        try {
            $api = new Api();
            return $api->getAssetDetail($assetId);
        } catch (Exception $e) {
            $this->errorLog(__FUNCTION__, 'error', $e->getMessage());
        }
    }

    public function updateSeparateAssetDetail()
    {
        try {
            $api = new Api();

            $ips = $domain = array();
            $ips = explode(',', $_POST['ip']);
            $domain = explode(',', $_POST['domain']);
            $clientId = $_POST['clientId'];
            $assetId = $_POST['assetId'];
            $data = [
                'domains' => $domain,
                'ips' => $ips
            ];
            return  $api->updateSeparateAssetDetail($assetId, $data);
        } catch (Exception $e) {
            $this->errorLog(__FUNCTION__, 'error', $e->getMessage());
        }
    }

    public function listClientAsset($client_id)
    {
        try {
            $asset = array();
            $api = new Api();

            $assets = $api->getClientDetailById($client_id)['response_json']['assets'];
            $message = array();
            if (sizeof($assets)) {
                foreach ($assets as $asset) {
                    $message[] = $api->getAssetDetail($asset)['response_json'];
                }
                return $message;
            }
        } catch (Exception $e) {
            $this->errorLog(__FUNCTION__, 'error', $e->getMessage());
        }
    }

    public function tentCidrs()
    {
        try {
            $asset = array();
            $api = new Api();

            $data =  $api->tentCidrs();
            if ($data['statuscode'] == 200) {
                return $data['response_json'];
            } else {
                return [];
            }
        } catch (Exception $e) {
            $this->errorLog(__FUNCTION__, 'error', $e->getMessage());
        }
    }

    public function getClientDetailById($client_id)
    {
        $api = new Api();
        $clientDetail = $api->getClientDetailById($client_id)['response_json'];
        return $clientDetail;
    }

    public function getWHMCSClientDetailById($client_id)
    {
        return Capsule::table('tblclients')->where('id', $client_id)->first();
    }

    public function clientAreaUserDetail($client_id)
    {
        try {
            $api = new Api();
            $clientAreaDetail = $api->getClientDetailById($client_id)['response_json'];

            $assets = $clientAreaDetail['assets'];
            $clientAreaDetail['totalAsset'] = sizeof($assets);
            $message = array();
            if (sizeof($assets)) {
                foreach ($assets as $asset) {
                    $message[] = $api->getAssetDetail($asset)['response_json'];
                }
            }
            $clientAreaDetail['getAssetsDetail'] = $message;
            return $clientAreaDetail;
        } catch (Exception $e) {
            $this->errorLog(__FUNCTION__, 'error', $e->getMessage());
        }
    }

    //get whmcs clients
    function getWhmcsClient()
    {
        try {
            return Capsule::table('tblclients')
                ->get();
        } catch (Exception $e) {
            $this->errorLog(__FUNCTION__, 'error', $e->getMessage());
        }
    }

    //get county code
    function getWhmcsCountry()
    {
        try {
            $country = new Country();
            return ($country->getCountry());
        } catch (Exception $e) {
            $this->errorLog(__FUNCTION__, 'error', $e->getMessage());
        }
    }

    // logs table

    public function getLogsTable()
    {
        try {

            global $whmcs;
            global $aInt;
            global $numrows;
            global $tabledata;
            global $orderby;
            global $order;
            global $page;
            global $limit;
            global $jscode;
            $page = 0;

            $aInt->rowLimit=50;

            global $CONFIG;
            if (!empty($whmcs->get_req_var('page'))) {
                $page = $whmcs->get_req_var('page');
            }
            
            $numrows = $this->gets_clients_logs__cpanel_count('mod_edgewatch_log');
            $responseData = $this->getrecordclient_capnel_Logs('mod_edgewatch_log', $page, $aInt->rowLimit);
            $aInt->sortableTableInit("datetime", "ASC");

            foreach ($responseData as $logdata) {
                $action = explode('::',$logdata->action)[1];
                $request = $logdata->request;
                $response = $logdata->response;
                $statuscode = $logdata->statuscode;
                $datetime = $logdata->datetime;
                $ip = $logdata->ip;

                $tabledata[] = array( $statuscode, $datetime, $ip,$action, '<textarea class="form-control" readonly>'.$request.'</textarea>', '<textarea class="form-control" readonly>'.$response.'</textarea>');
            }

            $table = $aInt->sortableTable(array( "Status Code", "Date", "IP","Action", "Request", "Response"), $tabledata);
            return $table;
        } catch (Exception $e) {
            logModuleCall('Guest User Module', 'List of Guest Users for the Selected Client', '', '', $e->getMessage());
        }
    }

    public function gets_clients_logs__cpanel_count($tableName)
    {
        $sql = Capsule::table($tableName);
        return $sql->count();
    }

    public function getrecordclient_capnel_Logs($tabelName, $page, $limit = 50,  $orderbyCol = 'id', $orderby = 'desc')
    {
        $sql = Capsule::table($tabelName);

        $sql->skip(($page) * $limit);
        $sql->take($limit);
        $sql->orderBy($orderbyCol, $orderby);
        $res =  $sql->get();
        return $res;
    }


    // end logs table code

    // log function
    private function returnStatus($action, $status, $message)
    {

        Capsule::table('mod_edgewatch_log')->insert([
            'action' => 'Helper::' . $action,
            'request' => '--',
            'response' => $message,
            'statuscode' => $status,
            'ip' => isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : ''
        ]);

        return ['action' => $action, 'status' => $status, 'message' => "$message"];
    }

    private function errorLog($action, $status, $message)
    {
        Capsule::table('mod_edgewatch_log')->insert([
            'action' => 'Helper::' . $action,
            'request' => '',
            'response' => json_encode(['error-log-type' => 'on try-catch', 'message' => $message], true),
            'statuscode' => $status,
            'ip' => isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : ''
        ]);
    }
}
