<?php

namespace WHMCS\Module\Addon\Edgewatch;
use WHMCS\Database\Capsule;
use WHMCS\Module\Addon\Edgewatch\Curl;
use WHMCS\Module\Addon\Edgewatch\Country;

class Api{
    
    public function __construct(){ 
    }

    public function createApiToken($clientId, $secreteKey ){
        $curl = new Curl();
        $curl->endPoint='auth/token';
        $curl->header =  [
            'Accept: application/json',
            "x-client-id: $clientId",
            "x-client-secret: $secreteKey"
        ];

        $response = $curl->curlCall();

        $response = $this->returnStatus('createApiToken', json_encode(['endpont'=>$curl->endPoint,'header'=>$curl->header]), $response['status_code'],$response['response']);
       
       
        return $response;
    } 

    public function getTenantDetail(){
        $token = Capsule::table('mod_edgewatch_auth')->value('token');
            $curl = new Curl();
            $curl->endPoint='tenant/me';
            $curl->header =  [
                'Accept: application/json',
                'Authorization: Bearer ' . $token
            ];
    
            $curlresponse = ($curl->curlCall());
            $response = $this->returnStatus(__FUNCTION__, json_encode(['endpont'=>$curl->endPoint,'header'=>$curl->header]), $curlresponse['status_code'],$curlresponse['response']);
            return $response;
    }

    public function tentCidrs(){
        $token = Capsule::table('mod_edgewatch_auth')->value('token');
            $curl = new Curl();
            $curl->endPoint='tenant/cidrs';
            $curl->header =  [
                'Accept: application/json',
                'Authorization: Bearer ' . $token
            ];
    
            $curlresponse = ($curl->curlCall());
            $response = $this->returnStatus(__FUNCTION__, json_encode(['endpont'=>$curl->endPoint,'header'=>$curl->header]), $curlresponse['status_code'],$curlresponse['response']);
            return $response;
    }

    public function getTentIssue(){
        $token = Capsule::table('mod_edgewatch_auth')->value('token');
            $curl = new Curl();
            $curl->endPoint='issues/me';
            $curl->header =  [
                'Accept: application/json',
                'Authorization: Bearer ' . $token
            ];
    
            $curlresponse = ($curl->curlCall());
            $response = $this->returnStatus(__FUNCTION__, json_encode(['endpont'=>$curl->endPoint,'header'=>$curl->header]), $curlresponse['status_code'],$curlresponse['response']);
            return $response;
    }


    public function getTenantAllAssets(){
        $token = Capsule::table('mod_edgewatch_auth')->value('token');
            $curl = new Curl();
            $curl->endPoint='assets/me';
            $curl->header =  [
                'Accept: application/json',
                'Authorization: Bearer ' . $token
            ];
    
            $curlresponse = ($curl->curlCall());
            $response = $this->returnStatus(__FUNCTION__, json_encode(['endpont'=>$curl->endPoint,'header'=>$curl->header]), $curlresponse['status_code'],$curlresponse['response']);
            return $response;
    }

    
    public function revokeToken(){
        $refreshToken = Capsule::table('mod_edgewatch_auth')->value('refresh_token');
        if($refreshToken!=''){
            $curl = new Curl();
            $curl->endPoint='auth/revoke';
            $curl->header =  [
                'Accept: application/json',
                'x-refresh-token: ' . $refreshToken
            ];
    
            $curlresponse = ($curl->curlCall());
            $response = $this->returnStatus('revokeToken', json_encode(['endpont'=>$curl->endPoint,'header'=>$curl->header]), $curlresponse['status_code'],$curlresponse['response']);

            print_r($response);
            die();
        }else{
            return ['action'=> 'revokeToken' , 'status' => 'error' , 'message' => 'refresh token is not exist'];
        }
    }

    public function createTenantClients($user){

        $tentclientDetail = ($this-> getApiTenantClients())['response_json'];
        $tentclientCompany =[];
        foreach($tentclientDetail as $key => $value){
            $tentclientCompany[] = $value['company'];
        }
        
        $userDetail = Capsule::table('tblclients')->where('id',$user)->first();

        if(in_array( $userDetail->companyname,$tentclientCompany)){
            $message = ['Company are already exit..'];
            $message = json_encode($message);
            $this->returnStatus(__FUNCTION__, $userDetail->email .'  Company namew: '. $userDetail->companyname, 5000,$message);
            return ['action'=>'createTenantClients', 'status' => 'error' , 'statuscode'=>5000, 'message'=>'Company are already exit..'];
        }else{
            $country = new Country();
            $country =  ($country->getCountry());
        
            $token = Capsule::table('mod_edgewatch_auth')->value('token');
            $curl = new Curl();
            $curl->endPoint='tenant/clients';
            $curl->header =  [
                'Accept: application/json',
                'Authorization: Bearer ' . $token,
                'Content-Type: application/json'
            ];


            $curl->method='POST';
            
            $ips=($userDetail->ip  != '')?$userDetail->ip :'';
            
            $country = ($userDetail->country  != '')?$country[$userDetail->country]['name'] :'';
        
            $curl->data = [
                "clients" => [
                    [
                        "name" => ($userDetail->firstname != '')?$userDetail->firstname:'' ,
                        "surname" => ($userDetail->lastname  != '')?$userDetail->lastname :'',
                        "email" => $userDetail->email,
                        "businessName" => ($userDetail->companyname  != '')?$userDetail->companyname :'',
                        "vatId" => ($userDetail->tax_id  != '')?$userDetail->tax_id :'',
                        "jobTitle" => "",
                        "country" => $country,
                        "province" => "",
                        "city" => ($userDetail->city  != '')?$userDetail->city :'',
                        "address" => $userDetail->address1.','.$userDetail->address2,
                        "postalCode" => ($userDetail->postcode  != '')?$userDetail->postcode :'',
                        "phone" => ($userDetail->phonenumber  != '')?$userDetail->phonenumber :'',
                        "domains" => [""],
                        "ips" => ["$ips"]
                    ]
                ]
            ];

            $curlresponse = ($curl->curlCall());
            $response = $this->returnStatus(__FUNCTION__, json_encode(['endpont'=>$curl->endPoint,'header'=>$curl->header,'data'=>$curl->data]), $curlresponse['status_code'],$curlresponse['response']);
            return $response;
        }
    }

    public function createAsset($data){

            $token = Capsule::table('mod_edgewatch_auth')->value('token');
            $curl = new Curl();
            $curl->endPoint='assets';
            $curl->header =  [
                'Accept: application/json',
                'Authorization: Bearer ' . $token,
                'Content-Type: application/json'
            ];


            $curl->method='POST';
        
            $curl->data = $data;

            $curlresponse = ($curl->curlCall());

            $response = $this->returnStatus(__FUNCTION__, json_encode(['endpont'=>$curl->endPoint,'header'=>$curl->header,'data'=>$curl->data]), $curlresponse['status_code'],$curlresponse['response']);
            return $response;
        
    }

    public function updateSeparateAssetDetail($assetId,$data){
        $token = Capsule::table('mod_edgewatch_auth')->value('token');
        $curl = new Curl();
        $curl->endPoint="assets/$assetId";
        $curl->header =  [
            'Accept: application/json',
            'Authorization: Bearer ' . $token,
            'Content-Type: application/json'
        ];

        $curl->method='PUT';
        $curl->data = $data;
        $curlresponse = ($curl->curlCall());

        $response = $this->returnStatus(__FUNCTION__, json_encode(['endpont'=>$curl->endPoint,'header'=>$curl->header,'data'=>$curl->data]), $curlresponse['status_code'],$curlresponse['response']);
        return $response;
    }

    public function getClientDetailById($clientId){
        $token = Capsule::table('mod_edgewatch_auth')->value('token');
            $curl = new Curl();
            $curl->endPoint="tenant/clients/$clientId";
            $curl->header =  [
                'Accept: application/json',
                'Authorization: Bearer ' . $token
            ];

            $curlresponse = ($curl->curlCall());

            $response = $this->returnStatus(__FUNCTION__, json_encode(['endpont'=>$curl->endPoint,'header'=>$curl->header,'data'=>$curl->data]), $curlresponse['status_code'],$curlresponse['response']);
            return $response;
    }

    public function getAssetDetail($asset){
        $token = Capsule::table('mod_edgewatch_auth')->value('token');
            $curl = new Curl();
            $curl->endPoint="assets/$asset";
            $curl->header =  [
                'Accept: application/json',
                'Authorization: Bearer ' . $token
            ];

            $curlresponse = ($curl->curlCall());

            $response = $this->returnStatus(__FUNCTION__, json_encode(['endpont'=>$curl->endPoint,'header'=>$curl->header,'data'=>$curl->data]), $curlresponse['status_code'],$curlresponse['response']);
            return $response;
    }

    public function getClientIssue($clientId){
        $token = Capsule::table('mod_edgewatch_auth')->value('token');
            $curl = new Curl();
            $curl->endPoint="issues/clients/$clientId";
            $curl->header =  [
                'Accept: application/json',
                'Authorization: Bearer ' . $token
            ];

            $curlresponse = ($curl->curlCall());

            $response = $this->returnStatus(__FUNCTION__, json_encode(['endpont'=>$curl->endPoint,'header'=>$curl->header,'data'=>$curl->data]), $curlresponse['status_code'],$curlresponse['response']);
            return $response;
    }

    public function getApiTenantClients(){
        $token = Capsule::table('mod_edgewatch_auth')->value('token');
            $curl = new Curl();
            $curl->endPoint='tenant/clients';
            $curl->header =  [
                'Accept: application/json',
                'Authorization: Bearer ' . $token
            ];
    
            $curlresponse = ($curl->curlCall());
            $response = $this->returnStatus(__FUNCTION__, json_encode(['endpont'=>$curl->endPoint,'header'=>$curl->header]), $curlresponse['status_code'],$curlresponse['response']);
            return $response;
    }
    
    private function returnStatus($action,$request,$statuscode,$response,$log='yes'){

        $response_json = json_decode($response,true);
        if($log=='yes'){
            Capsule::table('mod_edgewatch_log')->insert([
                'action' => 'API::'.$action,
                'request' => $request,
                'response' => $response,
                'statuscode' => $statuscode,
                'ip' => isset($_SERVER['REMOTE_ADDR'])?$_SERVER['REMOTE_ADDR']:''
            ]);
        }

        if($statuscode == 5000){}
        else if(isset($response_json['error']) || $statuscode!= 200){
            return ['action'=>$action, 'status' => 'error' , 'message' => $response_json['error'], 'statuscode'=>$statuscode, 'response_json'=>$response_json];
        }else{
            return ['action'=>$action, 'status' => 'success' , 'message' => '', 'statuscode'=>$statuscode,'response_json'=>$response_json];
        }
    }
}