<?php
namespace WHMCS\Module\Addon\Edgewatch\Admin;

use Exception;
use WHMCS\Database\Capsule;
use WHMCS\Module\Addon\Edgewatch\helper;
use Smarty;

class Controller
{
    private $params = [];
    private $tplFileName;
    private $tplVar = array();
    
    public function __construct($params)
    {
        global $CONFIG;
        $this->params = $params;
        $this->tplVar['rootURL'] = $CONFIG["SystemURL"];
        $this->tplVar['urlPath'] = $CONFIG["SystemURL"] . "/modules/addons/{$params['module']}/";
        $this->tplVar['moduleLink'] = $params['modulelink'];
        $this->tplVar['module'] = $params['module'];
        $this->tplVar['tplDIR'] = ROOTDIR . "/modules/addons/{$params['module']}/templates/admin/";
        $this->tplVar['header'] = ROOTDIR . "/modules/addons/{$params['module']}/templates/admin/include/header.tpl";
        $this->tplVar['footer'] = ROOTDIR . "/modules/addons/{$params['module']}/templates/admin/include/footer.tpl";
        $this->tplVar['cssPath'] = $CONFIG["SystemURL"] . "/modules/addons/{$params['module']}/assets/css";
        $this->tplVar['jsPath'] = $CONFIG["SystemURL"] . "/modules/addons/{$params['module']}/assets/js";
        $this->tplVar['asset'] = $CONFIG["SystemURL"] . "/modules/addons/{$params['module']}/assets";
       
    }

    public function api_connection()
    {
            $helper = new helper($this->params);

            if($_GET['wait'])
            {
                echo'<pre>';
                print_r(Capsule::table('mod_edgewatch_log')->get());
                die();
            }

            if($_POST['action']=='generate-api-token' && isset($_POST['action']) ){
                echo(json_encode($helper->generateApiToken()));
                die();
            }

            if($_POST['action']=='checkToken' && isset($_POST['action']) ){
                echo(json_encode($helper->getApiUserAllDetail()));
                die();
            }

            if($_POST['action']=='remove-api-token' && isset($_POST['action']) ){
                echo(json_encode($helper->deleteApiToken()));
                die();
            }

            $this->tplVar['apiDetail'] = Capsule::table('mod_edgewatch_auth')->first();
            $this->tplVar['user'] = $helper->getApiUser();
            $this->tplFileName = $this->tplVar['tab'] = __FUNCTION__;
            $this->tplVar['pageTitle'] = ' Api Configuration';
            $this->output();
    }

    public function dashboard(){
            $helper = new helper($this->params);
            $auth_user = $helper->getApiUser();
            $this->tplFileName  = $this->tplVar['tab'] = ( $auth_user != '')?__FUNCTION__: 'error';

            if($auth_user!= ''){
                $this->tplVar['TentClientDetail'] = $helper->getAllTentClientDetail();
              
                $this->tplVar['tentCidrs'] = $helper->tentCidrs();
            }

            $this->tplVar['pageTitle'] = 'Overview';
            $this->output(); 
    }

    public function syncclient(){
            $helper = new helper($this->params);

            if(isset($_POST['action']) && $_POST['action'] == "syncUser"){
                echo(json_encode($helper->syncUser()));
                die();
            }

            $auth_user = $helper->getApiUser();
            $this->tplFileName  = $this->tplVar['tab'] = ( $auth_user != '')?__FUNCTION__: 'error';
            $this->tplVar['tenantClients']=$helper->getTenantClients();
            $this->tplVar['users'] = $helper->getWhmcsClient();
            $this->tplVar['country'] = $helper->getWhmcsCountry();
            $this->tplVar['pageTitle'] = 'Customers';
            $this->output();
    }

    public function manageclientasset(){
            $helper = new helper($this->params);

            if(isset($_POST['action']) && $_POST['action'] == 'getAssetDetailById' ){
                echo(json_encode($helper->getAssetDetailById($_POST['assetId'])));
                die();
            }

            if(isset($_POST['action']) && $_POST['action'] == 'updateSeparateAssetDetail' ){
                echo(json_encode( $helper->updateSeparateAssetDetail()));
                die();
            }  

            $auth_user = $helper->getApiUser();
            $this->tplFileName  = $this->tplVar['tab'] = ( $auth_user != '')?__FUNCTION__: 'error';
            if(isset($_REQUEST['clientid'])){
                $this->tplVar['assetsData'] = $helper->listClientAsset($_REQUEST['clientid']);
                // $this->tplVar['clientDetail'] = $helper->getClientDetailById($_REQUEST['clientid']);
                $this->tplVar['clientDetail'] = $helper->getWHMCSClientDetailById($_REQUEST['wc']);
            }
            $this->tplVar['pageTitle'] = 'Manage Client Asset';
            $this->output();
    }
    
    public function logs()
    {

       

        try{
            $helper = new helper();

            if($_POST['action'] == 'deletelogs'){
                Capsule::table('mod_edgewatch_log')->delete();

                Capsule::table('mod_edgewatch_log')->insert([
                    'action' => 'Helper::Delete Logs',
                    'request' => "Delete By - #{$_SESSION['adminid']}",
                    'response' => 'Successfully Delete Previous Logs ',
                    'statuscode' => '200',
                    'ip' => isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : ''
                ]);

                die (json_encode(['status'=>"success"]));
            }

            $this->tplVar['tabledata'] =  $helper->getLogsTable();
            $this->tplFileName = $this->tplVar['tab'] = __FUNCTION__;
            $this->output();
        }catch(Exception $e){
            $this->output();
        }
    }

    public function error($errormessage){
        $this->output();
    }
    
    private function output()
    {
        $smarty = new Smarty();
        $smarty->assign('tplVar', $this->tplVar);
        if (!empty($this->tplFileName)) {
            $smarty->display($this->tplVar['tplDIR'] . $this->tplFileName . '.tpl');
        } else {
            $smarty->display($this->tplVar['tplDIR'] . 'error.tpl');
        }
    }
}
